*******************************
***** "Chile 2024" ***** 
******************************
clear
set more off
set type double
cap log close


/*Programa genera variables bases de ingresos CEPAL*/
cap program drop _clona_ingreso
program define _clona_ingreso
    args fuente destino

    cap drop `destino'
    gen `destino' = `fuente'
    replace `destino' = .z if `fuente' == 0
    replace `destino' = .m if inlist(`fuente', -88, -99)

    local lab : variable label `fuente'
    if "`lab'" != "" {
        label variable `destino' "`lab'"
    }
end



scalar t1 = c(current_time)

local dirbase "\CASEN 2024\chlca24"			// directorio con la base de datos original, archivo log e insumo archivo SAP
local dir2 "\CASEN 2024\chlca24"			// directorio con bases de datos intermedias y final, y programa labels

cap log close 
log using "`dirbase'\\generacion_ca24db06.log", text replace



qui{
	
	
	/*Corrección de asignación de tope de SAP*/
		
		import excel using "`dirbase'\\SAP_2024", sh(SAP2024_base) first			

		mkmat *, matrix(SAP)
		noi matrix list SAP

		
***********************************************
************** "Creación dn01" ****************
***********************************************


		noi use "`dirbase'\\250730_base_casen_2024_cepal_fe_var", clear	/*30 de julio*/
		compress 

		
/*EDICIÓN CASOS ESPECIALES*/

		/*Subsidio agua potable*/

		noi display _newline(2) "Subsidio Agua Potable" _newline(2)

		gen y24_o = y24 

		local casos = rowsof(SAP)

		forval x = 1/ `casos'  {
			replace y24 = SAP[`x',2] if comuna == SAP[`x',1] & y24> SAP[`x',2] & y24>0 & y24!=-88 & y24!=. 
			replace y24 = round(y24)  	
		}
		gen aux_SAP = y24 - y24_o 
		sum aux_SAP
		assert r(max) <= 0 & r(N) > 0 
		sum aux_SAP if aux_SAP < 0 
		noi display "El truncamiento provoca una disminución de " abs(r(mean)) " en promedio para las " r(N) " Obs truncadas, con disminuciones entre " r(min) " y " r(max)

		drop aux_SAP

		/*Bono trabajo mujer*/ 

		noi display _newline(2) "Bono trabajo mujer" _newline(2) 

		gen y25f_o = y25f
		replace y25f = 42377 if inlist(y25fp,1,-88) & y25f > 42377 & y25f!=. 	
		replace y25f = 646973 if y25fp == 2 & y25f > 646973	& y25f!=.		

		gen aux_BTM = y25f - y25f_o 
		sum aux_BTM
		assert r(max) <= 0 & r(N) > 0

		sum aux_BTM if aux_BTM < 0 & inlist(y25fp,1,-88)
		noi display "El truncamiento provoca una disminución de " abs(r(mean)) " en promedio para las " r(N) " Obs truncadas, con disminuciones entre " r(min) " y " r(max) " Para periodicidad mensual"

		sum aux_BTM if aux_BTM < 0 & inlist(y25fp,2,-88)
		noi display "El truncamiento provoca una disminución de " abs(r(mean)) " en promedio para las " r(N) " Obs truncadas, con disminuciones entre " r(min) " y " r(max) " Para periodicidad anual"

		drop aux_BTM

		/*Subsidio empleo joven*/ 

		noi display _newline(2) "Subsidio empleo jóven" _newline(2) 

		gen y25e_o = y25e
		replace y25e = 42377 if inlist(y25ep,1,-88) & y25e> 42377	& y25e!=.	
		replace y25e = 646973 if y25ep == 2 & y25e > 646973	& y25e!=.		

		gen aux_SEJ = y25e - y25e_o 
		sum aux_SEJ
		assert r(max) <= 0 & r(N) > 0

		sum aux_SEJ if aux_SEJ < 0 & inlist(y25ep,1,-88)
		noi display "El truncamiento provoca una disminución de " abs(r(mean)) " en promedio para las " r(N) " Obs truncadas, con disminuciones entre " r(min) " y " r(max) " Para periodicidad mensual"

		sum aux_SEJ if aux_SEJ < 0 & inlist(y25ep,2,-88)
		noi display "El truncamiento provoca una disminución de " abs(r(mean)) " en promedio para las " r(N) " Obs truncadas, con disminuciones entre " r(min) " y " r(max) " Para periodicidad anual"

		drop aux_SEJ

		save "`dir2'\\ca24dn01.dta", replace

	

************************************************************************************************************************************************
********* "Creación de dn02:generación de variables estandarizadas(factorex, id_hogar, id_pers, condact, ocupr, ramar, categ, anoest)" ********* 
********* "y generación de variables de ingreso mensualizadas a nivel persona"                     									   *********
************************************************************************************************************************************************


		cap confirm file "`dir2'\\ca24dn01.dta"
		if _rc != 0 continue 

		use "`dir2'\\ca24dn01.dta", clear


/* CONSTRUCCIÓN DE VARIABLES CEPAL*/

	/*Generación de mes y año*/

		gen mes = month(fecha_inicio_y)
		gen anio = year(fecha_inicio_y)
		
	/*Identificadores de hogar y persona, factorex, parentco*/

		gen factorex = expr

		bysort folio: gen id_hog = (_n == 1)
		gen id_hogar = sum(id_hog)
		drop id_hog

		noi duplicates report

		rename id_persona id_persona_orig
		sort id_hogar id_persona_orig
		by id_hogar: gen id_persona = _n

		gen parentco = pco1


	/* Condición de actividad */ 

		gen condact = 0 if edad < 15 									/* Menores de 15, no aplica*/
		replace condact = 1 if o1 == 1| o2 == 1 |o3 == 1 				/* Ocupados*/
		replace condact = 2 if o6 == 1 & (o4 == 1| o4 == 9)				/* Desocupados - cesante*/ 					
		replace condact = 3 if o6 == 1 & o4 == 2 						/* Desocupados - Buscan primera vez */				
		replace condact = 3 + o7 if (o7	>=1 & o7 <= 19)					/* Inactivos*/				
		replace condact = 99 if condact ==. & o7 == .					/* Ignorado */

		label define condact 0 "Menor de 15 años" 										///
							 1 "Ocupado" 												///
							 2 "Cesante" 												///
							 3 "Busca por primera vez" 									///
							 4 "Consiguio trabajo, empezara pronto" 					///
							 5 "Esperando resultado de gestiones" 						///
							 6 "Tiene que cuidar a niños/as" 							///
							 7 "Tiene que cuidar a adulto mayor" 						///
							 8 "Tiene que cuidar a otro familiar" 						///
							 9 "Enfermo o discapacitado" 								///
							10 "Piensa que nadie le dara trabajo" 						///
							11 "Condiciones laborales no le acomodan" 					///
							12 "Ofrecen sueldos muy bajos" 								///
							13 "Quehaceres del hogar" 									///
							14 "Estudiante" 											///
							15 "Jubilado(a), pensionado(a) o montepiado(a)" 			///
							16 "Tiene otra fuente de ingreso" 							///
							17 "Por temor a contagiarse de una enfermedad" 				///
							18 "Se canso de buscar" 									///
							19 "Cree que no hay trabajo disponible" 					///
							20 "Busca cuando lo necesita o tiene trabajo esporadico" 	///
							21 "No tiene interes en trabajar" 							///
							22 "Otra razon" 											///
							99 "NS/NR"
		label values condact condact

		
	/*Ocupacion primaria a un digito. CIUO 08*/

		gen ocupr = cond(condact == 1, oficio1_08, -1)
		replace ocupr = 99 if  inlist(ocupr,-99, -88, -66) 				
		replace ocupr = 99 if ocupr == . & condact ==1					

		label define ocup 	0 "Fuerzas Armadas" 														///
							1 "Gerentes" 																///
							2 "Profesionales" 															///
							3 "Técnicos y profesionales asociados" 										///
							4 "Trabajadores de apoyo administrativo" 									///
							5 "Trabajadores de servicios y ventas" 										///
							6 "Trabajadores calificados de la agricultura, la silvicultura y la pesca" 	///
							7 "Trabajadores de artesanía y oficios conexos" 							///
							8 "Operadores de plantas y máquinas y ensambladores" 						///
							9 "Ocupaciones elementales" 												///
							-1 "NA" 98 "No bien especificado" 99 "NS/NR"
		label values ocupr ocup

		
	/* Rama de ocupación a un digito. CIIU Rev 4*/ 

		gen ramar = cond(condact == 1, rama1_rev4, -1)
		replace ramar = 99 if inlist(ramar,-99, -88, -66) 		


		label define RAMA 	1 "Agricultura, ganadería silvicultura y pesca" 												///
							2 "Explotación de minas y canteras" 															///
							3 "Industrias manufactureras" 																	///
							4 "Suministro de electricidad, gas, vapor y aire acondicionado" 								///
							5 "Suministro de agua; evacuación de aguas residuales, gestión de desechos y descontaminación" 	///
							6 "Construcción" 																				///
							7 "Comercio al por mayor y al por menor, reparación de vehículos automotores y motocicletas" 	///
							8 "Transporte y almacenamiento" 																///
							9 "Actividades de alojamiento y de servicio de comidas" 										///
							10 "Información y comunicaciones" 																///
							11 "Actividades financieras y de seguros" 														///
							12 "Actividades inmobiliarias" 																	///
							13 "Actividades profesionales, científicas y técnicas" 											///
							14 "Actividades de servicios administrativos y de apoyo" 										///
							15 "Administración pública y defensa; planes de seguridad social de afiliación obligatoria" 	///
							16 "Enseñanza" 																					///
							17 "Actividades de atención de la salud humana y de asistencia social" 							///
							18 "Actividades artísticas, de entretenimiento y recreativas" 									///
							19 "Otras actividades de servicios" 															///
							20 "Los hogares como empleadores" 																///
							21 "Actividades de organizaciones y órganos extraterritoriales" 								///
							-1 "NA" 88 "No bien especificado" 99 "NS/NR"
		label values ramar RAMA


	/*Categoria ocupacional*/ 

		gen categ = cond((condact==1 & o15 >=1 & o15 <=9), o15, -1)
		replace categ = 99 if categ == .

		label define categ 	1"Patron o empleador" 							///
							2 "Trabajador por cuenta propia" 				///
							3 "Empleado u obrero del sector publico" 		///
							4 "Empleado u obrero de empresas publicas" 		///
							5 "Empleado u obrero del sector privado" 		///
							6 "Servicio domestico puertas adentro" 			///
							7"Servicio domestico puertas afuera" 			///
							8"FF.AA. y del orden" 							///
							9"Familiar no remunerado" 						///
							-1"NA" 99"NS/NR"
		label values categ categ
		

	/*ANOEST: años de educación*/

		gen anoest = . 

		/* Niveles iniciales */
		replace anoest = 0   if inlist(e6a, 1, 2, 3, 4)                        // nunca asistió, sala cuna, jardín infantil, prekinder/kinder
		replace anoest = 99  if inlist(e6a, 5)                                 // educación especial

		/* Educación básica */
		replace anoest = e6b if e6b >=1 & e6b <= 8 & e6a == 7                  // educación básica
		replace anoest = 0   if e6b == -88 & e6a == 7
		replace anoest = e6b if e6b >=1 & e6b <=6 & e6a == 6                   // primaria, sistema antiguo
		replace anoest = 0   if e6b == -88 & e6a == 6

		/* Educación media */
		replace anoest = 8 + e6b if e6b >=1 & e6b <=4 & e6a == 9               // educación media
		replace anoest = 8       if e6b == -88 & e6a == 9
		replace anoest = 8 + e6b if e6b >=1 & e6b <=5 & e6a == 11              // educación media sistema antiguo
		replace anoest = 8       if e6b == -88 & e6a == 11

		/* Humanidades y técnica antigua */
		replace anoest = 6 + e6b if e6b >=1 & e6b <=6 & e6a == 8               // humanidades, sistema antiguo
		replace anoest = 6       if e6b == -88 & e6a == 8
		replace anoest = 6 + e6b if e6b >=1 & e6b <=6 & e6a == 10              // técnica, comercial, industrial o normalista
		replace anoest = 6       if e6b == -88 & e6a == 10

		/* Técnico nivel superior */
		replace anoest = 12 + e6b if e6b >=1 & e6b <=3 & e6a == 12
		replace anoest = 12       if e6b == -88 & e6a == 12
		replace anoest = 15       if e6b == -88 & e6c_completo == 1 & e6a == 12

		/* Profesional */
		replace anoest = 12 + e6b if e6b >=1 & e6b <=10 & e6a == 13
		replace anoest = 12       if e6b == -88 & e6a == 13
		replace anoest = 17       if e6b == -88 & e6c_completo == 1 & e6a == 13

		/* Magíster */
		replace anoest = 12 + e6b + e6d_preg if e6b >=1 & e6b <=4 & e6d_preg>=1 & e6d_preg<=10 & e6a == 14
		replace anoest = 17 + e6b            if e6b >=1 & e6b <=4 & e6d_preg == -88 & e6a == 14
		replace anoest = 12 + e6d_preg       if e6b == -88 & e6d_preg>=1 & e6d_preg<=10 & e6a == 14
		replace anoest = 17                  if e6b == -88 & e6d_preg == -88 & e6a == 14
		replace anoest = 12 + e6d_preg + 2   if e6b == -88 & e6d_preg>=1 & e6d_preg<=10 & e6c_completo == 1 & e6a == 14
		replace anoest = 12 + e6d_preg       if e6b == -88 & e6d_preg>=1 & e6d_preg<=10 & e6c_completo == 2 & e6a == 14
		replace anoest = 19                  if e6b == -88 & e6d_preg == -88 & e6c_completo == 1 & e6a == 14

		/* Doctorado */
		replace anoest = 12 + e6b + e6d_preg + e6d_postg if e6b >=1 & e6b<=6 & e6d_preg>=1 & e6d_preg<=10 & e6d_postg>=0 & e6d_postg<=4 & e6a == 15
		replace anoest = 12 + e6b + e6d_preg + 2         if e6b >=1 & e6b<=6 & e6d_preg>=1 & e6d_preg<=10 & e6d_postg == -88 & e6a == 15
		replace anoest = 12 + e6d_preg + 2               if e6b == -88 & e6d_preg>=1 & e6d_preg<=10 & e6d_postg == -88 & e6a == 15
		replace anoest = 12 + 4 + e6d_preg + 2           if e6b == -88 & e6d_preg>=1 & e6d_preg<=10 & e6d_postg == -88 & e6c_completo == 1 & e6a == 15


		
/* CONSTRUCCIÓN DE AGREGADOS DE INGRESOS*/

		noi display "Variables de ingreso "

		
	/*SUELDOS Y SALARIOS*/

		*noi display _col(10) "Variables de ingreso -> |" _continue
		
		local sys1 "y1    y3a   y3b   y3c   y3d   y3e   y3f   y4a   y4b   y4c   y4d   y5a   y5b   y5c   y5d   y5e   y5f   y5g   y5h   y5i   y5j   y5k   y5l   y6    y10    y14b"
		local sys2 "y0101 y0301 y0302 y0303 y0304 y0305 y0306 y0401 y0402 y0403 y0404 y0501 y0502 y0503 y0504 y0505 y0506 y0507 y0508 y0509 y0510 y0511 y0512 y0601 y1001  aux01" 

		local n: word count `sys1'
		forvalues i = 1/`n' {
			local var1 : word `i' of `sys1' 
			local var2 : word `i' of `sys2'
			_clona_ingreso `var1' `var2'
		}
		
	
		/* Sueldos y salarios ocupación principal*/

			local sysp1  "y0301 y0302 y0303 y0304 y0305 y0306"
			local sysp1p "y3ap  y3bp  y3cp  y3dp  y3ep  y3fp"

			local i = 1
			local n: word count `sysp1'
			while `i' <= `n' {
				local var1 : word `i' of `sysp1' 
				local var2 : word `i' of `sysp1p'

				replace `var1' = `var1' 					if `var2' == 1 & `var1' >0 & `var1'!=. & `var1'!=.m
				replace `var1' = max(round(`var1' / 2),1)	if `var2' == 2 & `var1' >0 & `var1'!=. & `var1'!=.m
				replace `var1' = max(round(`var1' / 3),1)	if `var2' == 3 & `var1' >0 & `var1'!=. & `var1'!=.m
				replace `var1' = max(round(`var1' / 4),1) 	if `var2' == 4 & `var1' >0 & `var1'!=. & `var1'!=.m
				replace `var1' = max(round(`var1' / 6),1) 	if `var2' == 5 & `var1' >0 & `var1'!=. & `var1'!=.m
				replace `var1' = max(round(`var1' / 12),1) 	if `var2' == 6 & `var1' >0 & `var1'!=. & `var1'!=.m
				replace `var1' = `var1'					 	if (`var2' == -88 | `var2' == -99 | `var2' == .) & `var1' >0
				local i = `i' + 1
			}

			
			local sysp2 "y0401 y0402 y0403 y0404"
			
			foreach w of local sysp2 {
				replace `w' = max(round(`w'/12),1) if `w'>0 & `w'<. 
			}


		/* Sueldos y salarios ocupación secundaria*/
			
			egen yosa = rowtotal(y0601 y1001) if inlist(o30,3,4,5,6,7,8),m

		/* Sueldos y salarios otros */

			gen yta1 = cond(inlist(categ, 3,4,5,6,7,8),aux01, .)

		
		
	/*INGRESO POR TRABAJO INDEPENDIENTE*/

		local gan1 "y7    y8    y9    y17"
		local gan2 "y0701 y0801 y0901 yac2"

		local n: word count `gan1'
		forvalues i = 1/`n' {
			local var1 : word `i' of `gan1' 
			local var2 : word `i' of `gan2'
			_clona_ingreso `var1' `var2'
		}


		/*Ganancias de la ocupacion principal*/
		
			replace y0901 = max(round(y0901 / 12),1) if y0901 >0 & y0901 <. 

			/*Cambia ingresos del trabajo de no ocupados a y11*/

			local fnr1 "y11"
			local fnr2 "y1101"

			local n: word count `fnr1'
			forvalues i = 1/`n' {
				local var1 : word `i' of `fnr1' 
				local var2 : word `i' of `fnr2'
				_clona_ingreso `var1' `var2'
			}

			/*Revisión de ingresos de los no ocupados, distintos de y11*/
			noi list edad condact categ y0701 y0801 y0901 if (y0701>0 & y0701<. | y0801>0 & y0801<. | y0901>0 & y0901<.) & condact!=1

			/*Agrega a y1101 ingresos de los no ocupados declarados en otras corrientes*/
			egen y1101aux = rowtotal(y1101 y0701 y0801 y0901) if (categ<1 | categ>8) & y1101 == .,m
				replace y1101aux = y1101 if y1101>0 & y1101!=. & y1101!=.z & y1101!=.m
			drop y1101
			rename y1101aux y1101

			foreach var in y0701 y0801 y0901{
				replace `var' = . if condact!=1
			}


		/*Ganancias de la ocupacion secundaria*/

			egen yosi = rowtotal(y0601 y1001) if o30!=3 & o30!=4 & o30!=5 & o30!=6 & o30!=7 & o30!=8, m   


		/*Ganancias otras*/

			replace yac2 = max(round(yac2 / 12),1) if yac2 > 0 & yac2 <.

			gen yta2 = cond(categ!=3 & categ!=4 & categ!=5 & categ!=6 & categ!=7 & categ!=8,aux01, .)

			drop aux01 y0601 y1001



	/*INGRESOS DE CAPITAL*/

		local ycap1 "y12a y12b y15a y15b y15c y16a y16b"
		local ycap2 "yre1 yama yah1 yah2 yrut yre2 yre3"


		local n: word count `ycap1'
			forvalues i = 1/`n' {
				local var1 : word `i' of `ycap1' 
				local var2 : word `i' of `ycap2'
				_clona_ingreso `var1' `var2'
			}

		foreach v of var yah1 yah2 yrut yre2 yre3 {
			replace `v' = max(round(`v' /12),1) if `v' >0 & `v'<.
		}

		
	/*INGRESOS POR TRANSFERENCIAS CORRIENTES*/ 

		local yot1 "y13a y13b y13c y18a y18b y18c y18d"	
		local yot2 "ymes yfa1 yfa2 yids ydon ydim yotr"
	
		local n: word count `yot1'
			forvalues i = 1/`n' {
				local var1 : word `i' of `yot1' 
				local var2 : word `i' of `yot2'
				_clona_ingreso `var1' `var2'
			}
		
		foreach v of var ydon ydim yotr yids {
			replace `v' = max(round(`v'/12),1) if `v'>0 & `v'<.
		}
				
		list folio id_persona_orig y18d_esp if yotr>0 & yotr<.

		/*Se eliminan los casos que no corresponden a ingresos corrientes de yotr*/
		
		gen y18d_esp2 = ustrlower(y18d_esp)

		gen aux18esp = 0
		local excluir_yotr "herencia casa seguro falleci azar enero efectiva apuestas criptomonedas junio agosto septiembre fonasa entradas remanente"
		foreach w of local excluir_yotr {
			replace aux18esp = 1 if strpos(y18d_esp2, "`w'")
		}

		replace aux18esp = 1 if y18d_esp2 == "retiro de fondos, comenta el informante."
		replace aux18esp = 1 if y18d_esp2 == "devolución de excesos"
		replace aux18esp = 1 if y18d_esp2 == "devolución del crédito hipotecario"
				
		replace aux18esp = 0 if y18d_esp2 == "arrienda un espacio en su casa para guardar un vehículo." 
		replace aux18esp = 0 if y18d_esp2 == "seguro de cesantía" 
		replace aux18esp = 0 if y18d_esp2 == "prestación de servicios jurídicos. otro trabajo al ya declarado como trabajo secundario en módulo de ingresos de trabajo." 
		replace aux18esp = 0 if y18d_esp2 == "compensación económica por separación." 

		replace yotr = . if aux18esp == 1

		drop y18d_esp2 aux18esp

				
	/*PRESTACIONES DE LA SEGURIDAD SOCIAL Y SUBSIDIOS*/
		
		local yot1 "y14c y23a  y24   y25a  y25b  y25e  y25f  y27"	
		local yot2 "ydes y2301 y2401 y2501 y2502 y2505 y2506 y2701"
	
		local n: word count `yot1'
			forvalues i = 1/`n' {
				local var1 : word `i' of `yot1' 
				local var2 : word `i' of `yot2'
				_clona_ingreso `var1' `var2'
			}
		
	/*Ingresos por jubilaciones y pensiones*/

		local yjub1 "y29_2b  y29_6b 	y29_6b_1  	 y29_8b  	y29_8b_1	 y29_1c   y29_2d y29_4d     y29_5d 	   	 y29_2e   y29_2f y29_4f	    y29_5f     	 y29_2g y29_2h y29_4h	  y29_5h       y29_3i"
		local yjub2 "yjubt   yjub_pgu03 yjub_pgu03_1 yjub_aps03 yjub_aps03_1 yinv_pbs yinvt  yinv_aps03 yinv_aps03_1 yinv_con ymont  ymon_pgu03 ymon_pgu03_1 yorf   yespt  yesp_pgu03 yesp_pgu03_1 yotp"

		local n: word count `yjub1'
			forvalues i = 1/`n' {
				local var1 : word `i' of `yjub1' 
				local var2 : word `i' of `yjub2'
				_clona_ingreso `var1' `var2'
			}
		
		replace yotp = .z if yotp == . 
		replace yorf = .z if yorf == . 
		
		
		/*Pensión de vejez */
	
			/*Se incorpora a y290102, para los casos en que además se tiene monto total, los valores de PGU capturados en la pregunta de recuperación y29_m2_a2. Se agregan en los casos que la variable de rescate sea menor o igual a la variable de ingreso total*/
			replace yjub_pgu03 = y29_m2_a2 if y29_m2_a2 >0 & y29_m2_a2 <. & (yjub_pgu03 == . | yjub_pgu03 == .m) & yjubt >0 & yjubt<. & y29_m2_a2 <=yjubt
			
			/*Se genera la pension de vejez con PGU (para quienes declaran monto total) - parte contributiva por diferencia*/
			gen yjub_pgu02 = .z 
			replace yjub_pgu02 = yjubt - yjub_pgu03 if yjubt <. & yjub_pgu03 <.		

			/*Se agrega a la variable PGU la PGU declarada por quienes no declaran monto total*/
			replace yjub_pgu03 = yjub_pgu03_1 if yjub_pgu03_1>0 & (yjub_pgu03_1 <. ) & (yjub_pgu03 >= .)					

			/* Se genera variable de PGU aparte si solo se recibe PGU. Se toma la desición convencional con el MDS que PGU es única si monto total igual a monto PGU (y2903 = y290302)*/
			gen yjub_pgu01 = .z
			replace  yjub_pgu01 = yjub_pgu02 if yjubt == yjub_pgu02  
			
			/*Se agregan a la variable de "solo PGU" los montos de la variable de recuperación, si no tiene monto total quedan como solo PGU*/
			replace yjub_pgu01 = y29_m2_a2 if y29_m2_a2 >0 & y29_m2_a2 <. & (yjubt >= . )
			replace yjub_pgu03 = .z if yjub_pgu01>0 & yjub_pgu01<.  
			replace yjub_pgu03 = .z if yjub_pgu03 == . 
					
			/*Se agregan los valores de monto total >=214.000 y <215.000, para personas mayores de 65a cuando no han declarado más que el monto total */
			replace yjub_pgu01 = yjubt if yjubt >=214000 & yjubt <215000 & edad >=65 & (y29_6b == . | y29_6b == -88) & (y29_8b == . | y29_8b == -88)

			/*Si existe PGU se redistribuye y se vuelve a modificar el monto total (si existe) para evitar doble contabilización*/
			replace yjubt = 0 if yjub_pgu03>0 & yjub_pgu03<. & yjubt!=.m
			replace yjubt = 0 if yjub_pgu01>0 & yjub_pgu01<. & yjubt>0 & yjubt<.

			/*Se genera la pension de vejez con APS (para quienes declaran monto total) - parte contributiva por diferencia*/
			gen yjub_aps02 = .z
			replace yjub_aps02 = yjubt - yjub_aps03 if yjubt< .& yjub_aps03 <.		
			
			/*Se agrega a la variable APS la aps declarada por aquellos que no declaran monto total*/
			replace yjub_aps03 = yjub_aps03_1 if (yjub_aps03 >=.) & yjub_aps03_1  < . 	
			replace yjub_aps03 = .z if yjub_aps03 == .	
			
			/*Si existe APS se redistribuye y se vuelve a modificar el monto total para evitar doble contabilización*/
			replace yjubt = 0 if yjub_aps03!= 0 & yjub_aps03< . & yjubt < .

			/*Se genera variable para jubilaciones solo con ahorros previsionales, de acuerdo a variable y29_4b*/
			gen yjub_con = yjubt if (yjubt>0 & yjubt<.) & y29_4b == 1
			
			/*Se agregan a jubilaciones solo con ahorros previsionales los montos totales (menores de 214.000 o mayores de 215.000), para quienes declaran jubilación, tienen entre 60 y 65 años y no declaran monto de pgu o aps */
			replace yjub_con = yjubt if ((yjubt>0 & yjubt< 214000) | (yjubt>=215000 & yjubt<.)) & y29_3b == . & y29_4b == . & y29_5b == . & y29_7b == . & edad >=60 & edad < 65
			
			/* Se identifica no respuesta para imputación */
			replace yjub_con = .m if y29_2b == -88 & (y29_3b_1 == -88| y29_3b_1 == 2)

			/* Se modifica vble monto total para evitar doble contabilización*/
			replace yjubt = 0 if yjub_con>0 & yjub_con<.

			/*Los casos que no se pueden distribuir se asumen como pensión solo contributiva y se elimina la variable de monto total*/
			noi tab yjubt,m 
			replace yjub_con = yjubt if yjubt>0 & yjubt<. & yjub_con ==.
			replace yjubt = 0 if yjub_con >0 & yjub_con<. & yjubt>0 & yjubt<.
			replace yjub_con = .z if yjub_con == . 


		/*Pensión de invalidez (contributiva o APS)*/

			/* Se genera la pension de invalidez con APS - parte contributiva por diferencia*/
			gen yinv_aps02 = .z
			replace yinv_aps02 = yinvt - yinv_aps03 if yinvt < . & yinv_aps03 < .
			replace yinv_aps02 = .z if yinv_aps02 == 0  
			
			/*Se agrega a la variable aps la aps declarada por aquellos que no declaran monto total*/
			replace yinv_aps03 = yinv_aps03_1 if (yinv_aps03 == 0 | yinv_aps03>= .) & (yinv_aps03_1!= 0 & yinv_aps03_1< . )  
			replace yinv_aps03  = .z if yinv_aps03  == . 
			
			/*Se modifica monto total para evitar doble contabilización*/
			replace yinvt = 0 if yinv_aps03 >0 & yinv_aps03 <.
		

		/*PBS invalidez*/
		
			replace yinv_pbs = 214296 if yinv_pbs == 1			
			replace yinv_pbs = .z if yinv_pbs == 2   
			replace yinv_pbs = .z if yinv_pbs == .  
			
			noi tab yinvt,m 
			/*yinvt corresponde a la vble de monto total de la pensión de invalidez con APS,  existen 8 casos en que no se conoce el monto del APS, se agregan a la pensión contributiva, siguiendo el lineamiento de pensión de vejez*/
		
			replace yinv_con = yinvt if yinv_con == . & yinvt>0 & yinvt<.
			replace yinvt = 0 if yinvt>0 & yinvt<. & yinvt == yinv_con
			replace yinv_con = .z if yinv_con == . 


		/*Montepío*/

			/*Montepío con PGU, parte contributiva por diferencia*/
			gen     ymon_pgu02 = .z
			replace ymon_pgu02 = ymont - ymon_pgu03 if ymont>0 & ymont<. & ymon_pgu03>0 & ymon_pgu03<.
			replace ymon_pgu02 = .z if ymon_pgu02 == 0  
			replace ymon_pgu03 = ymon_pgu03_1 if (ymon_pgu03==0 | ymon_pgu03 >= .) & ymon_pgu03_1>0 & ymon_pgu03_1<.
			replace ymon_pgu03 = .z if ymon_pgu03 == .
			replace ymont      = 0 if ymon_pgu03 >=0 & ymon_pgu03 < .  
			replace ymont      = .m if ymont == 0 & y29_2f == -88		 

			/*Se genera montepío solo contributivo con las observaciones que quedan en la variable total y que no correspondían a montepío con PGU*/
			gen     ymon_con = .z
			replace ymon_con = ymont if ymont>0 & ymont<. & (ymon_pgu02 >=.) &  (ymon_pgu03 >= .)  

			/*Se modifica monto total para evitar doble contabilización*/
			replace ymont = 0 if ymon_con>0 & ymon_con<.

			/*Se elimina vble de monto total si está distribuida totalmente en el resto de las variables. Tres casos con monto total, dicen que reciben PGU pero no reportan el monto. Se agregan a montepío solo contributivo*/
			noi tab ymont,m 
			noi list folio  ymont y29_1f y29_2f y29_3f y29_4f y29_5f if  ymont>0 &  ymont<. & y29_3f == 1

		
		/*Leyes especiales*/
		
			gen yesp_pgu02 = .z  
			replace yesp_pgu02 = yespt - yesp_pgu03 if yespt>=0 & yespt < . & yesp_pgu03>=0 & yesp_pgu03 < . 
			replace yesp_pgu02 = .z if yesp_pgu02 == 0 
			
			replace yesp_pgu03 = yesp_pgu03_1 if yesp_pgu03_1>0 & (yesp_pgu03_1 < .) & (yesp_pgu03 >= . )
			replace yesp_pgu03 = .z if yesp_pgu03 == . 
			replace yespt = 0 if yesp_pgu03 >=0 & yesp_pgu03 <.
			replace yespt = .m if yespt == 0 & y29_2h == -88

			/*Se genera variable solo pension por leyes especiales, se incluye un caso con monto total >0 que dice que recibe PGU pero no reporta el monto. Se asume como sin PGU*/
			gen yesp = .z 
			replace yesp = yespt if yespt>0 & yespt<.
			replace yesp = .m if yespt == .m


	/* VALIDACIONES CONSISTENCIA PENSIONES*/	
	
		/*Valida PGU debe ser única entre las diversas preguntas*/
		gen pgu1 = (yjub_pgu01>0 & yjub_pgu01<.)			/*Solo PGU*/
		gen pgu2 = (yjub_pgu03>0 & yjub_pgu03<.)			/*Complemento PGU pensión de vejez*/
		gen pgu3 = (ymon_pgu03>0 & ymon_pgu03<.)			/*Complemento PGU montepío*/
		gen pgu4 = (yesp_pgu03>0 & yesp_pgu03<.)			/*Complemento PGU leyes especiales*/
		gen pgu = pgu1 + pgu2 + pgu3 + pgu4 

		quietly: count if pgu>1
		if r(N)  {
			noi display in red _newline(1) ///
				"***ATENCION: Problema con repetición de PGU en " r(N) " observaciones."

			noi list y29_2b y29_6b y29_6b_1 y2901 yjub_pgu03 y29_2f ymon_pgu03 ymon_pgu03_1 y29_2h yesp	yesp_pgu03 yesp_pgu03_1 ///
				if pgu>1, nolabel abbreviate(32)

			display in red _newline(1) "***ERROR: Proceso cancelado"
			exit 20007
		}

		/*Valida PGU vejez debe ser solo contributiva o no contributiva*/
		gen pguv1 = (yjub_pgu01>0 & yjub_pgu01<.)			/*Solo PGU*/
		gen pguv2 = (yjub_pgu03>0 & yjub_pgu03<.)			/*Complemento PGU pensión de vejez*/

		gen pguv = pguv1 + pguv2 

		quietly: count if pguv>1
		if r(N)  {
			noi display in red _newline(1) ///
				"***ATENCION: Problema con repetición de PGU en " r(N) " observaciones."

			noi list y29_2b y29_6b y29_6b_1 yjub_pgu01 yjub_pgu02 yjub_pgu03 ///
				if pguv>1, nolabel abbreviate(32)

			display in red _newline(1) "***ERROR: Proceso cancelado"
			exit 20007
		}

		drop pgu*

		/*Valida pensión de vejez recibida por una sola fuente*/
		gen pv1 = (yjub_pgu01>0 & yjub_pgu01<.)				/*PGU vejez*/
		gen pv2 = (yjub_aps03>0 & yjub_aps03<.) 			/*Vejez con APS*/
		gen pv3 = (yjub_pgu03>0 & yjub_pgu03<.) 			/*Vejez con PGU*/
		gen pv4 = (yjub_con>0 & yjub_con<.)					/*Vejez solo contributiva*/
		gen pv = pv1 + pv2 + pv3 + pv4

		quietly: count if pv>1
		if r(N)  {
			noi display in red _newline(1)		///
				"***ATENCION: Duplicación fuentes de pensión de vejez en " r(N) " observaciones."

			noi list y29_2b y29_6b y29_6b_1 yjub_pgu01 yjub_pgu02 yjub_pgu03 yjub_aps02 yjub_aps03 yjub_con 		///
				if pv>1, nolabel abbreviate(32)

			display in red _newline(1) "***ERROR: Proceso cancelado"
			exit 20008
		}

		drop pv*

		
	/*Ingresos por subsidios*/
	
		/*Control niño sano*/
			gen y2302 = cond(edad<=6 & y23b == 1, 11000, .)  
			replace y2302 = .m if y23b == -88
	
		/*Asistencia escolar*/
			gen y2303 = cond(edad>=6 & edad <=19 & y23c == 1, 11000, .)
			replace y2303 = .m if y23c == -88

		/*Aporte Familiar Permanente (ex – Bono Marzo) */
			gen double y25amonto = .
			replace y25amonto = 61793 * y25a if inrange(y25a,1,12)
			replace y25amonto = .m if y25a == -88

			replace y2501 = y25amonto if y25a_preg == 1 		
			replace y2501 = .z if y25a_preg == 2 | y25a_preg == .   		
			replace y2501 = .m if y25a_preg == -88 | y25a_preg == -99
			replace y2501 = .m if y25a_preg == 1 &  y25a == -88

		/*Bono logro escolar*/
			replace y2502 = 47187 if y25b == 1
			replace y2502 = 78642 if y25b == 2
			replace y2502 = .m if y25b == -88

		/*Bono bodas de oro*/
			gen y2503 = 212680 if y25c == 1 & edad>=60 
			replace y2503 = .m if y25c == -88

		/*Bono invierno*/
			gen y2504 = 77982 if y25d ==1 & edad >=65		
			replace y2504 = .m if y25d == -88
		
			foreach v of var y2501 y2502 y2503 y2504 {
				replace `v' = max(round(`v'/12),1) if `v'>0 & `v'<.
			}
			replace y2505 = max(round(y2505/12),1) if y2505>0 & y2505!=. & y2505!=.m & y2505!=.z & y25ep == 2  /*frecuencia anual*/
			replace y2506 = max(round(y2506/12),1) if y2506>0 & y2506!=. & y2506!=.m & y2506!=.z & y25fp == 2  /*frecuencia anual*/

		/*Otros subsidios: y27*/
		
			replace y2701 = max(round(y2701/12),1) if y27_preg == 2 & y2701!=. & y2701!= .m  /*Bonos anuales*/

			gen y27_esp2 = ustrlower(y27_esp)
			gen aux27 = (strpos(y27_esp2,"leña") | strpos(y27_esp2,"lena") | strpos(y27_esp2,"calefacci")) 

			replace aux27 = 0 if y27_esp2 == "bono de calefacción. subsidio de gas." 
			replace aux27 = 0 if y27_esp2 == "de calefacción le dieron parafina." 

			tab region if (y27_preg == 1 | y27_preg == 2) & aux27 == 1, m nol
			replace y2701 = . if aux27 == 1 & region != 11
			replace y2701 = max(round(y2701/12),1) if y2701 == 100000 & y27_preg == 1 & aux27 == 1

			/*Revisión de otros casos de y27*/
			list id_hogar id_persona_orig edad y27 y27_esp if (y27_preg == 1 | y27_preg == 2) & aux27 == 0
			drop aux27

			/*Se eliminan los casos que no corresponden de y2701*/
			gen aux27esp = 0
			local excluir_yotr "aguinaldo navidad patrias septiembre navideño"
			foreach w of local excluir_yotr {
				replace aux27esp = 1 if strpos(y27_esp2, "`w'") >0 & condact!=15 & condact!=9 		/*Aguinaldos de los jubilados y enfermos o discapacitados se mantienen*/
			}

			replace aux27esp = 0 if y27_esp2 == "aguinaldo de navidad para pensionados."
			replace aux27esp = 0 if y27_esp2 == "aguinaldo de jubilados" 
			replace aux27esp = 0 if y27_esp2 == "aguinaldo del estado" 
			replace aux27esp = 0 if y27_esp2 == "declara recibir un bono para fiestas patrias del estado."
			replace aux27esp = 0 if y27_esp2 == "subsidio eléctrico comunal desde septiembre." 

			replace y2701 = . if aux27esp == 1

			drop y27_esp2 aux27esp

		/*Asignación familiar*/

			tab y19t y19n,m

			gen yfam = y19n * 21243			if y19t == 1 & y19n>0 & y19n<99
				replace yfam = y19n * 13036 	if y19t == 2 & y19n>0 & y19n<99
				replace yfam = y19n * 4119 		if y19t == 3 & y19n>0 & y19n<99
				replace yfam = .m if y19t == -88 | ((y19n<=0 | y19n>=99) & inlist(y19t,1,2,3))
		
		/*SUF*/
		
			local yot3 "y20a	y20b	y20c	y20d	y20e" 		
			local yot4 "y2001	y2002 	y2003 	y2004 	y2005"

			local i = 1
			local n: word count `yot3'
			while `i' <= `n' {
				local var1 : word `i' of `yot3' 
				local var2 : word `i' of `yot4'
				gen `var2' = `var1' 
				replace `var2' = .z if `var1' == 2
				replace `var2' = .m if `var1' == -88 
				local lab: variable label `var1'
				label variable `var2' "`lab'"
				local i = `i' + 1
			}

			replace y2001 = 21243 if y2001 == 1
			replace y2002 = 212430 if y2002 == 1
			replace y2003 = 21243 if y2003 == 1
			replace y2004 = 42486 if y2004 == 1
			replace y2005 = 107148 if y20e == 1
			
			
			/*2024: SUF automático: <=17a, no recibe SUF recien nacido, SUF discapacidad + bolsillo electronico*/

			/*Valida que las personas que hayan declarado en y21 no reciban SUF al recien nacido o de discapacidad*/
			gen recibe_SUF = ((y2001>0 & y2001<.)|(y2004>0 & y2004<.))

			quietly: count if recibe_SUF == 1 & y21_preg == 1
			if r(N)  {
				noi display in red _newline(1) ///
					"***ATENCION: SUF duplicado en " r(N) " observaciones."

				noi list y20a y2001 y20b y2002 y20c y2003 y20d y2004 y19 yfam y21_preg y21 ///
					if (recibe_SUF == 1 | recibe_AF == 1) & y21 == 1, nolabel abbreviate(32)

				display in red _newline(1) "***ERROR: Proceso cancelado"
				exit 20012
			}	


			/*Se reemplaza por y21_preg == 2 si recibe_SUF 1 o edad fuera de rango*/
			gen y21_preg_i = y21_preg
			replace y21_preg_i = 2 if recibe_SUF == 1  & y21_preg ==1
			replace y21_preg_i = 2 if edad >17 & y21_preg == 1

			gen y210101 = 21243 if y21_preg_i == 1 & y21 == 1
			replace y210101 = 42486 if y21_preg_i == 1 & y21 == 2
			replace y210101 = .m if y21 == -88				

			drop recibe_* y21_preg_i

		/*Bolsillo familiar electrónico*/
			gen y21_bolsillo_i = y21_bolsillo
			replace y21_bolsillo_i = 2 if edad <=11		//solo lo pueden recibir mayores de 11a (se modifica una observación menor o igual a 11a)

			gen y210102 = 0
			replace y210102 = 13500 * y21_bolsillo_p if y21_bolsillo == 1 & y21_bolsillo_p!= -88 & y21_bolsillo_p!= . 				//se multiplica por número de causantes
			replace y210102 = 13500 if y21_bolsillo == 1 & (y21_bolsillo_p == -88 | y21_bolsillo_p== .) & (y21_bolsillo_m>0 & y21_bolsillo_m<.)			//para quienes declaran recibir bolsillo y el periodo pero no causante, se asume 1 causante, acordado con MDS siguiendo lo realizado en IFE

			// beneficio recibido de noviembre 2023 a abril 2024
			replace y210102 = y210102 * 6 if y210102 >0 & y210102<. & y21_bolsillo_m == 1 & fecha_inicio_y >= td(01nov2024) & fecha_inicio_y <= td(30nov2024)	//entrevistas realizadas en noviembre 2024
			replace y210102 = y210102 * 5 if y210102 >0 & y210102<. & y21_bolsillo_m == 1 & fecha_inicio_y >= td(01dec2024) & fecha_inicio_y <= td(31dec2024)	//entrevistas realizadas en diciembre 2024 (se incluyen solo los 12 meses anteriores)
			replace y210102 = y210102 * 4 if y210102 >0 & y210102<. & y21_bolsillo_m == 1 & fecha_inicio_y >= td(01jan2025) & fecha_inicio_y <= td(02feb2025)	//entrevistas realizadas en enero 2025 (se incluyen solo los 12 meses anteriores)

			//beneficio recibido de julio a sept 2024
			replace y210102 = y210102 * 3 if y210102 >0 & y210102<. & y21_bolsillo_m == 2					

			//beneficio recibido en ambos periodos
			replace y210102 = y210102 * 9 if y210102 >0 & y210102<. & y21_bolsillo_m == 3 & fecha_inicio_y >= td(01nov2024) & fecha_inicio_y <= td(30nov2024)	//entrevistas realizadas en noviembre 2024
			replace y210102 = y210102 * 8 if y210102 >0 & y210102<. & y21_bolsillo_m == 3 & fecha_inicio_y >= td(01dec2024) & fecha_inicio_y <= td(31dec2024)	//entrevistas realizadas en diciembre 2024 (se incluyen solo los 12 meses anteriores)
			replace y210102 = y210102 * 7 if y210102 >0 & y210102<. & y21_bolsillo_m == 3 & fecha_inicio_y >= td(01jan2025) & fecha_inicio_y <= td(02feb2025)	//entrevistas realizadas en enero 2025 (se incluyen solo los 12 meses anteriores)
			

			replace y210102 = round(y210102/12) if y210102>0 & y210102<.		//se mensualiza 
			replace y210102 = .m if y21_bolsillo_m == -88
			replace y210102 = .z if y21_bolsillo_m == .
			drop y21_bolsillo_i

		
		/*Valida edad y sexo SUF*/
		gen suf1 = 1 if y20a ==1 & edad>19
		gen suf2 = 1 if (y20b == 1 & sexo!= 2) | (y20b == 1 & (edad<=12 | edad>=59))
		gen suf3 = 1 if y20c == 1 & edad<12 
		gen suf4 = 1 if y20e == 1 & edad>19	

		gen cond_SUF = suf1 + suf2 + suf3 + suf4	
		quietly: count if cond_SUF >= 1 & cond_SUF<.
		if r(N)  {
			noi display in red _newline(1) ///
				"***ATENCION: Condiciones para SUF no se cumplen en " r(N) " observaciones"

			noi list edad sexo y20a y2001 y20b y2002 y20c y2003 y20d y2004 y20e y2005  ///
				if cond_SUF >= 1 & cond_SUF<., nolabel abbreviate(32)

			display in red _newline(1) "***ERROR: Proceso cancelado"
			exit 20011
		}		

		drop suf* cond_SUF
		
		/*Bono de protección familiar*/
			gen		y2201 = .z
			replace	y2201 = 22674 	if y22_preg == 1 & y22 == 1
			replace y2201 = .m 		if y22_preg == -88 | y22 == -88

			gen		y2202 = .z
			replace	y2202 = 17256 	if y22_preg == 1 & y22 == 2
			replace y2202 = .m 		if y22_preg == -88 | y22 == -88

			gen		y2203 = .z
			replace	y2203 = 11864 	if y22_preg == 1 & y22 == 3
			replace y2203 = .m 		if y22_preg == -88 | y22 == -88

			gen		y2204 = .z
			replace	y2204 = 21243 	if y22_preg == 1 & y22 == 4
			replace y2204 = .m 		if y22_preg == -88 | y22 == -88


		/*2024: SUBSIDIO ELECTRICO*/
		
			gen y2402 = .z				
			replace y2402 = 23890 if y24a == 1
			replace y2402 = 31056 if y24a == 2
			replace y2402 = 43001 if y24a == 3
			replace y2402 = .m if y24a == -88

			replace y2402 = round(y2402/12) if y2402 >0 & y2402<. 

	/*OTROS INGRESOS*/

		gen aux_y14a = (y14a> 0 & y14a <.)
		noi tab aux_y14a y14a_preg
		drop aux_y14a

		gen ytro = y14a if y14a_preg == 1
		replace ytro = .z if y14a == 0
		replace ytro = .m if y14a == -88


	/*Se calcula agregados de Ingreso */

		egen yaut = rowtotal(y0101 y0301 y0302 y0303 y0304 y0305 y0306 y0401 y0402 y0403 y0404 y0501 y0502 y0503 y0504 y0505 /*
			*/ y0506 y0507 y0508 y0509 y0510 y0511 y0512 yosa ytro yta1 y0701 y0801 y0901 yosi yta2 yrut yac2 ydes yids /*
		*/ yotr yjub_pgu02 yjub_aps02 yjub_con yinv_aps02 yinv_con ymon_pgu02 ymon_con yorf yotp yre1 yre2 yre3 yama yah1 yah2 ydon ymes yfa1 yfa2 y1101 ydim),m

		egen ysub = rowtotal(yfam y2001 y2002 y2003 y2004 y2005 y2201 y2202 y2203 y2204 y210101 y210102 y2301 y2302 y2303 y2401 y2402 /*
		*/y2501 y2502 y2503 y2504 y2505 y2506 y2701 yjub_pgu03 yjub_aps03 yjub_pgu01 yinv_aps03 yinv_pbs ymon_pgu03 yesp_pgu02 yesp_pgu03 yesp),m

		egen ytot = rowtotal(yaut ysub),m

		noi save "`dir2'\\ca24dn02.dta", replace

	

******************************************************************************************************************
************* "Creación de DB03: generación de variables sociodemográficas y de ingreso nivel hogar" *************
******************************************************************************************************************

		use "`dir2'\\ca24dn02", clear


	/*Se generan variables nivel hogar*/

		gen pers = 1

		gen persindo = 	cond(nucleo!= 0,1,0)		/*personas en el hogar sin considerar servicio doméstico(miembros del hogar)*/
		gen ncony = 	cond(parentco == 2 | parentco == 3, 1, 0)
		gen nhijosam = 	cond(parentco == 4, 1, 0)
		gen nhijossj = 	cond(parentco == 5, 1, 0)
		gen nhijossc = 	cond(parentco == 6, 1, 0)
		gen npadres = 	cond(parentco == 7, 1, 0)
		gen nsuegros =  cond(parentco == 8, 1, 0)
		gen nyerno =	cond(parentco == 9, 1, 0)
		gen nnieto =	cond(parentco == 10, 1, 0)
		gen nherman =	cond(parentco == 11, 1, 0)
		gen ncunados = 	cond(parentco == 12, 1, 0)
		gen notrop =	cond(parentco == 13, 1, 0)
		gen notronp =	cond(parentco == 14, 1, 0)
		gen dom =		cond(nucleo == 0, 1, 0)
		gen nocup = 	cond(condact == 1 & nucleo!= 0,1,0)
		gen ndesocup =	cond((condact == 2 | condact == 3) & nucleo!= 0,1,0)

		gen nninos04 = cond(nucleo!= 0 & edad <=4, 1, 0)
		gen np12ym =   cond(nucleo!= 0 & edad >=12, 1, 0)
		gen np15ym =   cond(nucleo!= 0 & edad >=15, 1, 0)
		gen np25ym =   cond(nucleo!= 0 & edad >=25, 1, 0)
		gen estsum15 = anoest if np15ym == 1 & anoest>0 & anoest <99
		gen estsum25 = anoest if np25ym == 1 & anoest>0 & anoest <99


	/*Agregados de ingreso nivel hogar*/

		local agreing "y0101 y0301 y0302 y0303 y0304 y0305 y0306 y0401 y0402 y0403 y0404 y0501 y0502 y0503 y0504 y0505 y0506 y0507 y0508 y0509 "
		local agreing "`agreing' y0510 y0511 y0512 yosa ytro yta1 y0701 y0801 y0901 yosi yta2 yrut yac2 ydes yids yotr yjub_pgu02 yjub_aps02 yjub_con "
		local agreing "`agreing' yinv_aps02 yinv_con ymon_pgu02 ymon_con yorf yotp yre1 yre2 yre3 yama yah1 yah2 ydon ymes yfa1 yfa2 y1101 ydim"
		local agreing "`agreing' yfam y2001 y2002 y2003 y2004 y2005 y2201 y2202 y2203 y2204 y210101 y210102 y2301 y2302 y2303 y2401 y2402 y2501 y2502 y2503 y2504 "
		local agreing "`agreing' y2505 y2506 y2701 yjub_pgu03 yjub_aps03 yjub_pgu01 yinv_aps03 yinv_pbs ymon_pgu03 yesp_pgu02 yesp_pgu03 yesp"
		local agreing "`agreing' yaut ysub ytot"

		foreach var of local agreing {
			gen `var'h = cond(nucleo!= 0 & `var'>0,`var',0)
		}

		
		local varjef "sexo edad condact ocupr ramar categ anoest"

		foreach var of local varjef {
			gen `var'j = cond(parentco==1,`var',-1)
		}

		sort id_hogar

		collapse (max) sexoj edadj anoestj condactj ocuprj ramarj categj (sum) pers-ytoth ,by(id_hogar) 

		rename anoestj educj

		save "`dir2'\\ca24temp", replace


	/*Se une la base a nivel de personas con las variables agregadas hogar*/
	
		use "`dir2'\\ca24dn02", clear

		sort id_hogar
		merge m:1 id_hogar using "`dir2'\\ca24temp"
		drop _merge

		compress

		
	/* Alquiler imputado*/

		gen yaimh = 0 
		replace yaimh = cond(parentco == 1 & v13!= 2 & v19>0 & v19!= ., v19, 0)
		bysort id_hogar: egen aux_yaimh = max(yaimh)
		bysort id_hogar: replace yaimh = aux_yaimh
		
		drop aux_yaimh

		replace ytoth = ytoth + yaimh
		gen ypch = round(ytoth / persindo)

		save "`dir2'\\ca24dn03", replace


***************************************************************************************************************
**************Creación de DN04: Corrección por no respuesta de ingresos de ocupados y jubilados****************
***************************************************************************************************************

		use "`dir2'\\ca24dn03", clear


	/*Crea variables de control recodificadas*/ 

		gen paren1 = cond(parentco == 1, 1, 2)

		recode anoest (0/3 = 1) (4/7 = 2) (8/11 = 3) (12 = 4) (13/25 = 5) (99 = 1), into(niveduc)
		recode niveduc (1/3 = 1) (4/5 = 2), into(niveduc1)

		recode ramar (0 = 7) (-1 = -1) (1 = 1) (2 = 2) (3 6 = 3) (4 5 = 4) (7/10 = 5) (11/12 = 6) (13/21 = 7), into(ramar1)
		replace ramar1 = cond(categ == 8, .,ramar1)		/*en FFAA no se considera ni rama ni ocupación*/

		gen ramar2 = ramar
		replace ramar2 = cond(categ == 8, .,ramar)

		recode region (1/5 15 = 1) (6/12 14 16= 2) (13 = 13), into(reg1)

		recode edad (0/14 = 1) (15/24 = 2) (25/44 = 3) (45/64 = 4) (else = 5), into(tred1)
		recode edad (0/59 = 1) (60/69 = 2) (70/79 = 3) (else = 4), into(tredadam)

		recode categ (4 = 5) (6 = 7), into(categ1)
		recode categ1 (5 8 = 3), into(categ2) 

		recode ocupr (0 = 8) (5/7 10 = 5) (8 = 6) (9 = 7), into(ocupr1)
		replace ocupr1 = cond(categ == 1|categ == 8, ., ocupr1)			/*en empleadores no se considera ocupación*/ /*en FFAA no se considera ni rama ni ocupación*/


	/*Corrección ingresos de los ocupados*/

		/*Reemplazos en y1 y y7 para distinguir 0 y no responden de missing + generación de vbles para corte de colas (p1,p99)*/

		replace y0101 = .z if y1 == 0
		replace y0101 = .m if y1 == -88

		replace y0701 = .z if y7 == 0
		replace y0701 = .m if y7 == -88

		tabstat y0101 y0701 if y0101>0 & y0701>0, s(min p1 p50 p99 max) save f(%12.0f)
		mat YL = r(StatTotal)
		noi mat list YL

		gen y0101p1 = YL[2,1]
		gen y0101p99 = YL[4,1]
		gen y0701p1 = YL[2,2]
		gen y0701p99 = YL[4,2]


		gen y0101c = y0101
		gen y0701c = y0701

		local paso1 "comuna ramar2 tred1 categ 	niveduc  condact sexo ocupr1"
		local paso2 "region ramar2 tred1 categ 	niveduc  condact sexo ocupr1"
		local paso3 "region ramar1 tred1 categ 	niveduc  condact sexo ocupr1"
		local paso4 "region ramar1 tred1 categ1 niveduc  condact sexo ocupr1"
		local paso5 "region ramar1 tred1 categ1 niveduc1 condact sexo ocupr1"
		local paso6 "reg1 	ramar1 tred1 categ1 niveduc1 condact sexo ocupr1"
		local paso7 "reg1 	ramar1 tred1 categ2 niveduc1 condact sexo ocupr1"


		gen aux1_im = 1

		forval p = 1/7 {

			di _n(1) "Paso `p'"

			foreach v of var y0101 y0701 {
				preserve
				if "`v'" == "y0101" {
					keep if `v'>0 & `v'!=.m & `v'!=. & `v'!=.z & `v'>`v'p1 & `v'<`v'p99 & condact== 1 & categ>=3 & categ<=8
				}
				else if "`v'" == "y0701" {
					keep if `v'>0 & `v'!=.m & `v'!=. & `v'!=.z & `v'>`v'p1 & `v'<`v'p99 & condact== 1 & categ>=1 & categ<=2
				}
				collapse (mean) `v' [aw = factorex], by(`paso`p'')
				ren `v' _`v'
				save "`dir2'\\temp`p'_`v'", replace
				restore
			}

			di "Casos a imputar y0101"
			count if y0101c == .m & condact == 1 & categ>=3 & categ<=8   			/*Casos a imputar y0101*/

			tab aux1_im  if y0101c == .m & condact == 1 & categ>=3 & categ<=8, miss	
			local y0101c_`p' = r(N) // casos a imputar

			tab aux1_im  if y0101c != .m & (y0101c > 0 | y0101c == .z) & condact == 1 & categ>=3 & categ<=8, miss	
			local y0101c_`p'_inf = r(N) // casos con datos


			merge m:1 `paso`p'' using "`dir2'\\temp`p'_y0101"
			tab _merge
			replace y0101c = round(_y0101) if y0101c == .m & _merge == 3 & condact == 1 & categ>=3 & categ<=8 

			sum y0101 [aw = factorex] if condact== 1 & categ>=3 & categ<=8
			local media_sin_imp = r(mean)

			sum y0101c [aw = factorex] if condact== 1 & categ>=3 & categ<=8
			local media_imp = r(mean)

			sum y0101c [aw = factorex] if condact== 1 & categ>=3 & categ<=8 & y0101c != y0101
			local media_imputados = r(mean)

			tab aux1_im  if y0101c == .m & condact == 1 & categ>=3 & categ<=8, miss	
			local imputados = `y0101c_`p'' - r(N) // casos a imputar

			noi display "y0101" _col(20) "`p'" _col(30) `media_sin_imp' _col(50) `media_imputados'  _col(70) `media_imp' _col(90) `y0101c_`p'' _col(110) `imputados'


			drop _merge

			di "Casos a imputar y0701"
			count if y0701c ==.m & condact == 1 & inlist(categ,1,2) 				/*Casos a imputar y0701*/
			tab aux1_im  if y0701c == .m & condact == 1 &  inlist(categ,1,2), m
			local y0701c_`p' = r(N) // casos a imputar

			tab aux1_im  if y0701c != .m & (y0701c > 0 | y0701c == .z) & condact == 1 & inlist(categ,1,2), miss	
			local y0701c_`p'_inf = r(N) // casos con datos

			merge m:1 `paso`p'' using "`dir2'\\temp`p'_y0701"
			tab _merge
			replace y0701c = round(_y0701) if y0701c ==.m & _merge == 3 & condact == 1 & inlist(categ,1,2) 

			sum y0701c [aw = factorex] if  condact == 1 & inlist(categ,1,2)
			local media_sin_imp = r(mean)

			sum y0701c [aw = factorex] if  condact == 1 & inlist(categ,1,2)
			local media_imp = r(mean)

			sum y0701c [aw = factorex] if condact == 1 & inlist(categ,1,2) & y0701c != y0701
			local media_imputados = r(mean)

			tab aux1_im  if y0701c == .m & condact == 1 &  inlist(categ,1,2), m
			local imputados = `y0701c_`p'' - r(N) // casos a imputar

			noi display "y0701" _col(20) "`p'" _col(30) `media_sin_imp' _col(50) `media_imputados'  _col(70) `media_imp' _col(90) `y0701c_`p'' _col(110) `imputados'

			drop _merge

			summ y0101 y0101c y0701 y0701c
			drop _y0101 _y0701
		}

		
		noi di "Casos sin imputar y0101"
		noi count if y0101c == .m & condact == 1 & categ>=3 & categ<=8   				/*Casos sin imputar y0101*/
		tab aux1_im  if y0101c == .m & condact == 1 & categ>=3 & categ<=8, miss	
		local y0101c_8 = r(N) // casos a imputar
		tab aux1_im  if y0101c != .m & (y0101c > 0 | y0101c == .z) & condact == 1 & categ>=3 & categ<=8, miss	
		local y0101c_8_inf = r(N) // casos con datos

		noi di "Casos sin imputar y0701"
		noi count if y0701c ==.m & condact == 1 & inlist(categ,1,2) 					/*Casos sin imputar y0701*/
		tab aux1_im  if y0701c == .m & condact == 1 &  inlist(categ,1,2), m
		local y0701c_8 = r(N) // casos a imputar

		tab aux1_im  if y0701c != .m & (y0701c > 0 | y0701c == .z) & condact == 1 & inlist(categ,1,2), miss	
		local y0701c_8_inf = r(N) // casos con datos

		noi display "var" _col(20) "P" _col(25)  "obs"   _col(45)   "NR"
		foreach v of var y0101c y0701c {
			forvalues p = 1/8{

				noi display "`v'" _col(20) `p' _col(25)  ``v'_`p'_inf'   _col(45)   ``v'_`p''

			}
		}

		
	/*Corrección de jubilaciones y pensiones de vejez*/

		tabstat yjub_con if yjub_con>0, s(min p1 p50 p99 max) save f(%12.0f)
		mat YJ = r(StatTotal)
		noi mat list YJ

		gen yjub_conp1 = YJ[2,1]
		gen yjub_conp99 = YJ[4,1]

		gen yjub_conc = yjub_con
		replace yjub_conc = . if yjub_conc == .m
		noi replace yjub_conc = yjubt if yjubt == .m & (yjub_pgu01 == .z | yjub_pgu01 ==.m) & (yjub_pgu02 ==.z | yjub_pgu02 ==.m) & (yjub_pgu03 ==.z | yjub_pgu03 ==.m) & (yjub_aps02 ==.z | yjub_aps02 ==.m) & (yjub_aps03 ==.z | yjub_aps03 ==.m) 
		

		local paso1_jub "comuna paren1 sexo niveduc tredadam"
		local paso2_jub "region paren1 sexo niveduc tredadam"
		local paso3_jub "region paren1 sexo niveduc"

		noi display "variable" _col(20) "paso" _col(30) "media_orig" _col(50) "Media_imp"  _col(70) "media_final" _col(90) "N_imputar" _col(110) "N_imputados"

		forval p = 1/3 {

			di _n(1) "Paso `p' jub"

			foreach v of var yjub_con {
				preserve

				if "`v'" == "yjub_con" {
					keep if `v'>0 & `v'!=.m & `v'!=. & `v'!= .z & `v'>`v'p1 & `v'<`v'p99 & y29_4b == 1
				}

				collapse (mean) `v' [aw = factorex], by(`paso`p'_jub')

				ren `v' _`v'
				save "`dir2'\\temp`p'_`v'", replace

				restore
			}


			di "Casos a imputar yjub_con"
			count if yjub_conc == .m 				/*Casos a imputar yjub_con*/
			tab aux1_im  if yjub_conc == .m, miss	
			local yjub_conc_`p' = r(N) // casos a imputar
			tab aux1_im  if yjub_conc != .m & (yjub_conc > 0 | yjub_conc == .z) & yjub_conc != . , miss	
			local yjub_conc_`p'_inf = r(N) // casos con datos

			merge m:1 `paso`p'_jub' using "`dir2'\\temp`p'_yjub_con"
			tab _merge
			replace yjub_conc = round(_yjub_con) if yjub_conc == .m & _merge == 3 

			sum yjub_con [aw = factorex] if y29_4b == 1
			local media_sin_imp = r(mean)

			sum yjub_conc [aw = factorex] if y29_4b == 1
			local media_imp = r(mean)

			sum yjub_conc [aw = factorex] if y29_4b == 1 & yjub_conc != yjub_con
			local media_imputados = r(mean)

			tab aux1_im   if yjub_conc == .m , miss	
			local imputados = `yjub_conc_`p'' - r(N) // casos a imputar


			noi display "yjub_con" _col(20) "`p'" _col(30) `media_sin_imp' _col(50) `media_imputados'  _col(70) `media_imp' _col(90) `yjub_conc_`p'' _col(110) `imputados'

			drop _merge
			summ  yjub_con _yjub_con
			drop  _yjub_con 
		}


		noi di "Casos sin imputar yjub_con"
		noi count if yjub_conc == .m  	/*Casos sin imputar yjub_con*/
		tab aux1_im  if yjub_conc == .m , miss	
		local yjub_conc_4 = r(N) // casos a imputar
		tab aux1_im  if yjub_conc != .m & (yjub_conc > 0 | yjub_conc == .z)  & yjub_conc != . , miss	
		local yjub_conc_4_inf = r(N) // casos con datos


		noi display "var" _col(20) "P" _col(25)  "obs"   _col(45)   "NR"
		foreach v of var yjub_conc {
			forvalues p = 1/4{

				noi display "`v'" _col(20) `p' _col(25)  ``v'_`p'_inf'   _col(45)   ``v'_`p''

			}
		}

		
	/*Genera variables corregidas a nivel hogar*/
		
		bysort id_hogar: egen y0101ch = sum(y0101c) if nucleo!= 0 & y0101c>0
		replace y0101ch = 0 if y0101ch == .
		bysort id_hogar: egen y0701ch = sum(y0701c) if nucleo!= 0 & y0701c>0
		replace y0701ch = 0 if y0701ch == .
		bysort id_hogar: egen yjub_conch = sum(yjub_conc) if nucleo!= 0 & yjub_conc>0
		replace yjub_conch = 0 if yjub_conch == .

		drop aux1_im	
		drop paren1 niveduc niveduc1 ramar1 ramar2 reg1 tred1 tredadam categ1 categ2 ocupr1 yjub_conp1 yjub_conp99 y0101p1 y0101p99 y0701p1 y0701p99


	/*Genera agregados corregidos*/

		egen yautcor = rowtotal(y0101c y0301 y0302 y0303 y0304 y0305 y0306 y0401 y0402 y0403 y0404 y0501 y0502 y0503 y0504 y0505 /*
			*/ y0506 y0507 y0508 y0509 y0510 y0511 y0512 yosa ytro yta1 y0701c y0801 y0901 yosi yta2 yrut yac2 ydes yids /*
		*/ yotr yjub_pgu02 yjub_aps02 yjub_conc yinv_aps02 yinv_con ymon_pgu02 ymon_con yorf yotp yre1 yre2 yre3 yama yah1 yah2 ydon ymes yfa1 yfa2 y1101 ydim),m

		egen ytotcor = rowtotal(yautcor ysub),m

		save "`dir2'\\ca24dn04", replace


*********************************************************************************************************************************
****************"Creación DN05: crea agregados de ingreso corregidos nivel hogar y se incorporan a la base"**********************
*********************************************************************************************************************************

		use "`dir2'\\ca24dn04", clear

		local agreingco "yautcor ytotcor"  

		foreach var of local agreingco {
			gen `var'h = cond(nucleo!= 0,`var',0)
		}	

		gen nrecep = cond(nucleo!= 0 & ytotcor>0 & ytotcor!=. , 1, 0)		/*Se genera número de perceptores de ingreso del hogar posterior a la corrección por no respuesta*/

		sort id_hogar
		collapse (sum) yautcorh ytotcorh nrecep, by(id_hogar) 

		save "`dir2'\\ca24temp1", replace

		use "`dir2'\\ca24dn04", clear
		merge m:1 id_hogar using "`dir2'\\ca24temp1"
		tab _merge
		drop _merge


		save "`dir2'\\ca24dn05", replace
	


*******************************************************************************************************************
************* "Creación de DN06: corrección de alquiler imputado y generación de variable de pobreza" ************* 
*******************************************************************************************************************
	
		use "`dir2'\\ca24dn05.dta", clear

		/* Se incorpora el valor de la línea de pobreza e indigencia (Noviembre 2024) https://observatorio.ministeriodesarrollosocial.gob.cl/storage/docs/cba/nueva_serie/2024/Valor_CBA_y_LPs_24.11.pdf*/ 

		gen li= 157804		
		gen lp= 236705		


	/*Alquiler imputado*/

		/*Generación de matriz de alquiler*/

		gen v1_orig = v1

		gen v13_orig = v13
		replace v13= 1 if v13 == 1 & v13_propia == 1
		replace v13= 2 if v13 == 1 & v13_propia == 2
		replace v13= 3 if v13 == 1 & v13_propia == 3
		replace v13= 4 if v13 == 1 & v13_propia == 4
		replace v13= 5 if v13 == 2 & v13_arrendada == 5
		replace v13= 6 if v13 == 2 & v13_arrendada == 6
		replace v13= 7 if v13 == 3 & v13_cedida == 7
		replace v13= 8 if v13 == 3 & v13_cedida == 8

		label define sit_viv 	1 "Propia pagada" 													///
								2 "Propia pagándose" 												///
								3 "Propia compartida (pagada) con otros hogares de la vivienda" 	///
								4 "Propia compartida (pagándose) con otros hogares de la vivienda" 	///
								5 "Arrendada con contrato" 											///
								6 "Arrendada sin contrato" 											///
								7 "Cedida por servicio o trabajo" 									///
								8 "Cedida por familiar u otro" 										///
								9 "Usufructo (sólo uso y goce)" 									///
								10 "Ocupación irregular (de hecho)" 								///
								11 "Poseedor irregular"

		label value v13 sit_viv


		matrix YAIM = J(9,9,0)
		matrix rownames YAIM = 1 2 3 4 5 6 7 8 9 
		matrix colnames YAIM = 1 2 3 4 5 6 7 8 9	

		gen v19_orig = v19
		replace v19= 0 if v19==.

		sum v19 [aw=factorex] if parentco == 1 & v19 > 0 & v19 < ., d
		local v19_p1 = r(p1)
		local v19_p99 = r(p99)

		noi di "`v19_p1'" _col(30) "`v19_p99'"

		forval x = 1/9 {
			forval y = 1/9 {
				sum v19 [aw=factorex] if parentco == 1 & v1 ==`x' & v13 == `y' & v19> `v19_p1' & v19 < `v19_p99'
				if `y'!=5 & `y'!=6 {
					matrix YAIM[`x', `y'] = r(mean)
				}
				else {
					matrix YAIM[`x', `y'] = .
				}
			}
		}

		matrix list YAIM 


		gen yaicoh_aux = 0

		forval x = 1/9 {
			forval y = 1/9 {
				replace yaicoh_aux = YAIM[`x',`y'] if yaimh == 0 & v1 ==`x' & v13 == `y' & YAIM[`x',`y']>0 
				replace yaicoh_aux = YAIM[`x',1] if yaimh == 0 & v1 ==`x' & YAIM[`x',`y']<= 0
			}
		}

		preserve
		keep id_hogar yaimh v1 v13 parentco
		keep if parentco == 1

		gen y2 = yaimh
		sort v1 v13 id_hogar 
		by v1 v13: replace y2 = y2[_n-1] if y2 == 0 & y2[_n-1]!=0 & y2[_n-1]>`v19_p1' & y2[_n-1]<`v19_p99'

		save "`dir2'\\temp_ai.dta", replace

		sum yaimh          if yaimh == 0 & inlist(v13,1,2,3,4,7,8,9)
		sum y2                if y2 == 0 & inlist(v13,1,2,3,4,7,8,9)

		restore

		merge m:1 id_hogar using "`dir2'\\temp_ai", keepus(y2)

		gen yaimcorh = cond(inlist(v13,1,2,3,4,7,8,9),round(y2,1), 0)
		replace yaimcorh = 0 if yaimcorh == .
		replace yaimcorh = round(yaicoh_aux,1) if yaimcorh == 0 & inlist(v13,1,2,3,4,7,8,9)
		replace yaimcorh = 0 if y0503h > 0 & v13_cedida == 7                   /* En cedidas por servicio o trabajo se toma como alquiler imputado el pago en vivienda si este es mayor que cero */
		replace yaimcorh = 0 if yaimcorh == .

		sum yaimcorh if yaimcorh == 0 & inlist(v13,1,2,3,4,7,8,9)

		drop yaicoh_aux _merge y2

		replace ytotcorh = ytotcorh + yaimcorh


	/* Calculo  POBREZA*/ 

		gen ypc = round(ytotcorh /persindo)
		gen nae = persindo^0.7
		gen yae = round(ytotcorh / nae)

		gen pobreza = 3
		replace pobreza = 2 if yae < lp
		replace pobreza = 1 if yae < li

		label define pobreza 1 "Pobreza extrema" 2 "Pobreza no extrema" 3 "Fuera de la pobreza" 
		label values pobreza pobreza


		/* Se dejan variables de ingreso final y pobreza en 0 para nucleo==0*/

		replace ytotcorh = . if nucleo == 0
		replace ypc =. if nucleo == 0
		replace yae =. if nucleo == 0
		replace pobreza =. if nucleo == 0

		sort region area comuna id_vivienda id_hogar id_persona

		drop yjubt yinvt ymont yespt yjub_pgu03_1 yjub_aps03_1 yinv_aps03_1 ymon_pgu03_1 yesp_pgu03_1 

		do "`dir2'\\_labels_chl24dn06.do" 

		foreach var of varlist y0101 - yae{
			
			tab `var' if `var' > . , miss 
		
			if r(N) > 0 {
				replace `var' = . if `var' > . 
				noi display "Se cambian `r(N)' observaciones .m y/o .z a . en `var'"
				tab `var' if `var' > . 
				if r(N) > 0 error 
			}
		}

	
		compress 
		save "`dir2'\\ca24dn06_mds", replace

		cap log close

		noi display "Finaliza"

	
	scalar t2 = c(current_time)

	noi display (clock(t2, "hms") - clock(t1, "hms")) / 1000 " seconds"
}